/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils.math;

import com.hybridlab.utils.ThreePerpendicularAxes;
import com.hybridlab.utils.math.Rectangle3D;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Plane;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.Locale;

public class MathUtils {
    public static Quaternion createQuaternionWithEulerAnglesDeg(float angleXDeg, float angleYDeg, float angleZDeg) {
        float[] angles = new float[]{angleXDeg * ((float)Math.PI / 180), angleYDeg * ((float)Math.PI / 180), angleZDeg * ((float)Math.PI / 180)};
        Quaternion q = new Quaternion(angles);
        return q;
    }

    public static float signedAngleBetween2Vectors(Vector2f v1, Vector2f v2) {
        float angle1 = FastMath.atan2((float)v1.y, (float)v1.x);
        float angle2 = FastMath.atan2((float)v2.y, (float)v2.x);
        return angle1 - angle2;
    }

    public static String quaternionToAxisAngleInDegreesString(Quaternion r) {
        return MathUtils.quaternionToAxisAngleInDegreesString(r, "2");
    }

    public static float[] quaternionToEulerAnglesInRad(Quaternion rotation) {
        float[] anglesRad = new float[3];
        rotation.toAngles(anglesRad);
        return anglesRad;
    }

    private static String quaternionToAxisAngleInDegreesString(Quaternion r, String formatpart) {
        float[] anglesRad = new float[3];
        r.clone().toAngles(anglesRad);
        float rx = anglesRad[0] * 57.295776f;
        float ry = anglesRad[1] * 57.295776f;
        float rz = anglesRad[2] * 57.295776f;
        return String.format(Locale.ENGLISH, "rx=%3." + formatpart + "f ry=%3." + formatpart + "f rz=%3." + formatpart + "f q(x %3." + formatpart + "f y %3." + formatpart + "f z %3." + formatpart + "f w %3." + formatpart + "f)", Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(rz), Float.valueOf(r.getX()), Float.valueOf(r.getY()), Float.valueOf(r.getZ()), Float.valueOf(r.getW()));
    }

    public static Object quaternionToAxisAngleInDegreesString(Quaternion rotation, int i) {
        return MathUtils.quaternionToAxisAngleInDegreesString(rotation, String.valueOf(Math.abs(i)));
    }

    public static ThreePerpendicularAxes getQuaternionAxes(Quaternion q) {
        Vector3f[] axes = new Vector3f[3];
        q.clone().toAxes(axes);
        ThreePerpendicularAxes r = new ThreePerpendicularAxes();
        r.X = axes[0];
        r.Y = axes[1];
        r.Z = axes[2];
        return r;
    }

    public static boolean isConvexVolumeIfConnected(Rectangle3D a, Rectangle3D b) {
        Vector3f na = a.getNormal();
        Vector3f nb = b.getNormal();
        Plane pa = new Plane(na, na.dot(a.getCenter()));
        Plane pb = new Plane(nb, na.dot(b.getCenter()));
        Plane[] testplanes = new Plane[]{pa, pb};
        Rectangle3D[] testRectangles = new Rectangle3D[]{b, a};
        for (int i = 0; i < 2; ++i) {
            Plane plane = testplanes[i];
            Rectangle3D rect = testRectangles[i];
            Plane.Side expectedside = null;
            for (Vector3f corner : rect.getCorners()) {
                Plane.Side side = plane.whichSide(corner);
                if (side.equals((Object)Plane.Side.None)) continue;
                if (expectedside == null) {
                    expectedside = side;
                    continue;
                }
                if (expectedside.equals((Object)side)) continue;
                return false;
            }
        }
        return true;
    }

    public static Quaternion createQuaternionFromAxisAngleDeg(Vector3f axis, float angleInDegrees) {
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(angleInDegrees * ((float)Math.PI / 180), axis);
        return q;
    }

    public static boolean AABBoxesIntersect(AABBox a, AABBox b) {
        float[] cb = b.getCenter();
        float[] ca = a.getCenter();
        float[] halfsizes_a = new float[]{0.5f * a.getWidth(), 0.5f * a.getHeight(), 0.5f * a.getDepth()};
        float[] halfsizes_b = new float[]{0.5f * b.getWidth(), 0.5f * b.getHeight(), 0.5f * b.getDepth()};
        boolean[] intersections = new boolean[]{false, false, false};
        for (int i = 0; i < 3; ++i) {
            float d = FastMath.abs((float)(cb[i] - ca[i]));
            intersections[i] = d - halfsizes_a[i] - halfsizes_b[i] < 0.0f;
        }
        return intersections[0] && intersections[1] && intersections[2];
    }

    public static ColorRGBA ensureNotDarkerThan(float f, ColorRGBA regularFrameColorOfSatellite) {
        regularFrameColorOfSatellite.b = Math.max(regularFrameColorOfSatellite.b, f);
        regularFrameColorOfSatellite.r = Math.max(regularFrameColorOfSatellite.r, f);
        regularFrameColorOfSatellite.g = Math.max(regularFrameColorOfSatellite.g, f);
        return regularFrameColorOfSatellite;
    }

    public static boolean equalsRounded(Vector3f a, Vector3f b) {
        if (MathUtils.round(a.x) != MathUtils.round(b.x)) {
            return false;
        }
        if (MathUtils.round(a.y) != MathUtils.round(b.y)) {
            return false;
        }
        return MathUtils.round(a.z) == MathUtils.round(b.z);
    }

    private static float round(float v) {
        return (float)Math.round(v * 10.0f) * 0.1f;
    }

    public static Quaternion snapSimple(Quaternion rot, float snapAngleRad) {
        Vector3f[] axes = new Vector3f[3];
        rot.toAxes(axes);
        Vector3f z = axes[2];
        float angleToGlobalY = z.angleBetween(Vector3f.UNIT_Y);
        if (angleToGlobalY < snapAngleRad) {
            Vector3f x = axes[0];
            x.y = 0.0f;
            x.normalizeLocal();
            Vector3f y = x.cross(Vector3f.UNIT_Y).negate();
            rot = rot.fromAxes(x, y, Vector3f.UNIT_Y);
            return rot;
        }
        if ((float)Math.PI - angleToGlobalY < snapAngleRad) {
            Vector3f x = axes[0];
            x.y = 0.0f;
            x.normalizeLocal();
            Vector3f y = x.cross(Vector3f.UNIT_Y.negate()).negate();
            rot = rot.fromAxes(x, y, Vector3f.UNIT_Y.negate());
            return rot;
        }
        if (Math.abs(angleToGlobalY - 1.5707964f) < snapAngleRad) {
            Vector3f rotationaxis = Vector3f.UNIT_Y.cross(z);
            Quaternion snaprotation = new Quaternion();
            snaprotation.fromAngleAxis(1.5707964f - angleToGlobalY, rotationaxis);
            return snaprotation.mult(rot);
        }
        return rot;
    }

    public static void swing_twist_decomposition(Quaternion rotation, Vector3f direction, Quaternion swing, Quaternion twist) {
        Vector3f ra = new Vector3f(rotation.getX(), rotation.getY(), rotation.getZ());
        Vector3f p = ra.project(direction);
        twist.set(p.x, p.y, p.z, rotation.getW());
        twist.normalizeLocal();
        Quaternion inverseTwist = twist.inverse();
        swing = rotation.mult(inverseTwist);
    }

    public static Quaternion calculateDifferenceTwist(Quaternion referenceRotation, Quaternion currentRotation, Vector3f twistAxis) {
        Quaternion twist_ref = new Quaternion();
        Quaternion swing_ref = new Quaternion();
        Vector3f direction = twistAxis;
        MathUtils.swing_twist_decomposition(referenceRotation, direction, swing_ref, twist_ref);
        Quaternion twist = new Quaternion();
        Quaternion swing = new Quaternion();
        Vector3f direction2 = twistAxis;
        MathUtils.swing_twist_decomposition(currentRotation, direction2, swing, twist);
        Quaternion diffTwist = twist_ref.inverse().mult(twist);
        return diffTwist;
    }

    public static Quaternion snapButKeepRotationAxis(Quaternion referenceRotation, Quaternion inputRotation, float snapThresholdRad, Vector3f rotationAxis) {
        ThreePerpendicularAxes refAxes = MathUtils.getQuaternionAxes(referenceRotation);
        ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(inputRotation);
        float angleToX = refAxes.X.angleBetween(rotationAxis);
        float angleToY = refAxes.Y.angleBetween(rotationAxis);
        if (rotationAxis.angleBetween(Vector3f.UNIT_Y) < 1.7453292E-4f) {
            return inputRotation;
        }
        Quaternion r = new Quaternion();
        Vector3f n = rotationAxis.cross(Vector3f.UNIT_Y);
        Vector3f m = n.cross(rotationAxis);
        float angle_Z_n = n.angleBetween(axes.Z);
        float angle_Z_m = m.angleBetween(axes.Z);
        if (Math.abs(angle_Z_n) < snapThresholdRad) {
            r.fromAxes(rotationAxis, m, n);
            return r;
        }
        if (Math.abs((float)Math.PI - angle_Z_n) < snapThresholdRad) {
            r.fromAxes(rotationAxis, m.negate(), n.negate());
            return r;
        }
        if (Math.abs(angle_Z_m) < snapThresholdRad) {
            r.fromAxes(rotationAxis, n.negate(), m);
            return r;
        }
        if (Math.abs((float)Math.PI - angle_Z_m) < snapThresholdRad) {
            r.fromAxes(rotationAxis, n, m.negate());
            return r;
        }
        return inputRotation;
    }

    public static boolean isPowerOfTwo(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number: " + number);
        }
        return (number & -number) == number;
    }
}

