/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.xmltools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractXMLFile {
    private File file = null;
    protected Document document = null;
    protected boolean hasChanges = false;
    protected String rootNodeName = "XmlFile";
    protected XPath xPath = null;
    private boolean fileExisted = false;

    public boolean fileWasNewlyCreated() {
        return !this.fileExisted;
    }

    public AbstractXMLFile(File file, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        this.init(file, rootNodeName);
    }

    public AbstractXMLFile(String filename, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        this.init(filename, rootNodeName);
    }

    public AbstractXMLFile(String filename) throws ParserConfigurationException, SAXException, IOException {
        this.init(filename, this.rootNodeName);
    }

    public AbstractXMLFile(byte[] xmlBytes, String tagnameRootnode) throws ParserConfigurationException, SAXException, IOException {
        this.init(xmlBytes, tagnameRootnode);
    }

    protected void init(byte[] xmlBytes, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        this.rootNodeName = rootNodeName;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        ByteArrayInputStream filestream = new ByteArrayInputStream(xmlBytes);
        this.document = builder.parse(filestream);
        this.document.normalize();
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    protected Node getRootNode() {
        NodeList rootNodeElements = this.document.getElementsByTagName(this.rootNodeName);
        if (rootNodeElements.getLength() == 1) {
            return rootNodeElements.item(0);
        }
        return null;
    }

    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    protected File getFile() {
        return this.file;
    }

    protected void init(String filename, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        File f = new File(filename);
        this.init(f, rootNodeName);
    }

    protected void init(File f, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        this.file = f;
        this.rootNodeName = rootNodeName;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        if (f.exists()) {
            this.fileExisted = true;
            FileInputStream filestream = new FileInputStream(this.file);
            this.document = builder.parse(filestream);
        } else {
            this.fileExisted = false;
            if (this.document == null) {
                this.document = builder.newDocument();
                Element rootElement = this.document.createElement(this.rootNodeName);
                this.document.appendChild(rootElement);
                this.hasChanges = true;
            }
        }
        this.document.normalize();
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    protected void removeAllNodesUnderParentNode() {
        Node rootNode = this.getNode("", null, false);
        if (null != rootNode) {
            AbstractXMLFile.removeAllChildNodes(rootNode);
        }
    }

    protected Node createNodeUnderNode(Node parent, String nodeName) {
        Element newelem = this.document.createElement(nodeName);
        Node node = parent.appendChild(newelem);
        this.hasChanges = true;
        return node;
    }

    protected Node createNodeUnderRootNode(String Path2) {
        String fullpath = "/" + this.rootNodeName + (String)(Path2.startsWith("/") ? Path2 : "/" + Path2);
        return this.createNodeByFullPath(fullpath);
    }

    protected Node createNodeByFullPath(String fullPath) {
        if (null == fullPath || 0 == fullPath.length()) {
            return null;
        }
        Node result = null;
        String[] parts = (fullPath = fullPath.substring(1)).split("/");
        if (parts == null || parts.length == 0 || parts[0].compareTo(this.rootNodeName) != 0) {
            throw new ArithmeticException("Invalid path");
        }
        String subpath = "/" + parts[0];
        try {
            Node parent = (Node)this.xPath.evaluate(subpath, this.document, XPathConstants.NODE);
            Node node = null;
            for (int i = 1; i < parts.length; ++i) {
                node = (Node)this.xPath.evaluate(subpath = subpath + "/" + parts[i], this.document, XPathConstants.NODE);
                if (null == node) {
                    Element newelem = this.document.createElement(parts[i]);
                    node = parent.appendChild(newelem);
                }
                parent = node;
            }
            result = node;
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
            return null;
        }
        this.hasChanges = true;
        return result;
    }

    protected static void removeAllChildNodes(Node node) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            if (childNode.hasChildNodes()) {
                AbstractXMLFile.removeAllChildNodes(childNode);
            }
            node.removeChild(childNode);
        }
    }

    public void saveNoMatterIfUnchanged() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(this.file);
        transformer.transform(source, result);
    }

    public void save() throws TransformerException, IOException {
        if (this.hasChanges) {
            this.saveNoMatterIfUnchanged();
        }
    }

    public ByteArrayOutputStream getAsStream() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        return out;
    }

    public Node getNode(String path, String defaultValue, boolean createIfNotexists) {
        String fullPath = path.length() > 0 ? "/" + this.rootNodeName + (String)(path.startsWith("/") ? path : "/" + path) : "/" + this.rootNodeName;
        Node result = null;
        try {
            result = (Node)this.xPath.evaluate(fullPath, this.document, XPathConstants.NODE);
            if (null == result && createIfNotexists) {
                result = this.createNodeByFullPath(fullPath);
                result.setTextContent(defaultValue);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }
}

