/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.parser;

import com.momchil_atanasov.data.front.parser.OBJDataReference;
import com.momchil_atanasov.data.front.parser.OBJNormal;
import com.momchil_atanasov.data.front.parser.OBJObject;
import com.momchil_atanasov.data.front.parser.OBJTexCoord;
import com.momchil_atanasov.data.front.parser.OBJVertex;
import java.util.ArrayList;
import java.util.List;

public class OBJModel {
    private final List<OBJVertex> vertices = new ArrayList<OBJVertex>();
    private final List<OBJTexCoord> texCoords = new ArrayList<OBJTexCoord>();
    private final List<OBJNormal> normals = new ArrayList<OBJNormal>();
    private final List<OBJObject> objects = new ArrayList<OBJObject>();
    private final List<String> materialLibraries = new ArrayList<String>();

    public List<OBJVertex> getVertices() {
        return this.vertices;
    }

    public OBJVertex getVertex(OBJDataReference reference) {
        return this.vertices.get(reference.vertexIndex);
    }

    public List<OBJTexCoord> getTexCoords() {
        return this.texCoords;
    }

    public OBJTexCoord getTexCoord(OBJDataReference reference) {
        return this.texCoords.get(reference.texCoordIndex);
    }

    public List<OBJNormal> getNormals() {
        return this.normals;
    }

    public OBJNormal getNormal(OBJDataReference reference) {
        return this.normals.get(reference.normalIndex);
    }

    public List<OBJObject> getObjects() {
        return this.objects;
    }

    public OBJObject getObject(String name) {
        for (OBJObject object : this.objects) {
            if (!name.equals(object.getName())) continue;
            return object;
        }
        return null;
    }

    public List<String> getMaterialLibraries() {
        return this.materialLibraries;
    }
}

