/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.parser;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.common.IFastInt;
import com.momchil_atanasov.data.front.common.OBJLimits;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.parser.OBJDataReference;
import com.momchil_atanasov.data.front.parser.OBJFace;
import com.momchil_atanasov.data.front.parser.OBJMesh;
import com.momchil_atanasov.data.front.parser.OBJModel;
import com.momchil_atanasov.data.front.parser.OBJNormal;
import com.momchil_atanasov.data.front.parser.OBJObject;
import com.momchil_atanasov.data.front.parser.OBJTexCoord;
import com.momchil_atanasov.data.front.parser.OBJVertex;
import com.momchil_atanasov.data.front.scanner.IOBJScannerHandler;
import com.momchil_atanasov.data.front.scanner.OBJLimitingScannerHandler;
import com.momchil_atanasov.data.front.scanner.OBJScanner;
import java.io.BufferedReader;
import java.io.IOException;

class OBJParseRunner
implements IOBJScannerHandler {
    private OBJModel model;
    private OBJObject currentObject;
    private OBJMesh currentMesh;
    private OBJFace currentFace;

    public OBJModel run(BufferedReader reader, OBJLimits limits) throws WFException, IOException {
        this.currentFace = null;
        this.currentMesh = null;
        this.currentObject = null;
        this.model = new OBJModel();
        OBJScanner scanner = new OBJScanner();
        if (limits == null) {
            scanner.scan(reader, (IOBJScannerHandler)this);
        } else {
            scanner.scan(reader, (IOBJScannerHandler)new OBJLimitingScannerHandler(this, limits));
        }
        return this.model;
    }

    @Override
    public void onComment(String comment) throws WFException {
    }

    @Override
    public void onVertex(IFastFloat x, IFastFloat y, IFastFloat z, IFastFloat w) throws WFException {
        OBJVertex vertex = new OBJVertex(x.get(), y.get(), z.get());
        this.model.getVertices().add(vertex);
    }

    @Override
    public void onNormal(IFastFloat x, IFastFloat y, IFastFloat z) throws WFException {
        OBJNormal normal = new OBJNormal(x.get(), y.get(), z.get());
        this.model.getNormals().add(normal);
    }

    @Override
    public void onTextureCoordinate(IFastFloat u, IFastFloat v, IFastFloat w) throws WFException {
        OBJTexCoord texCoord = new OBJTexCoord(u.get());
        if (v != null) {
            texCoord.v = v.get();
            texCoord.type = OBJTexCoord.Type.TYPE_2D;
        }
        if (w != null) {
            texCoord.w = w.get();
            texCoord.type = OBJTexCoord.Type.TYPE_3D;
        }
        this.model.getTexCoords().add(texCoord);
    }

    @Override
    public void onObject(String objectName) throws WFException {
        this.currentMesh = null;
        this.currentObject = new OBJObject(objectName);
        this.model.getObjects().add(this.currentObject);
    }

    @Override
    public void onFaceBegin() throws WFException {
        this.assureCurrentMesh();
        this.currentFace = new OBJFace();
        this.currentMesh.getFaces().add(this.currentFace);
    }

    @Override
    public void onFaceEnd() throws WFException {
        if (this.currentFace.getReferences().size() < 3) {
            throw new WFCorruptException("Face does not have at least three vertices.");
        }
    }

    @Override
    public void onDataReference(IFastInt vertexIndex, IFastInt texCoordIndex, IFastInt normalIndex) throws WFException {
        OBJDataReference reference = new OBJDataReference();
        reference.vertexIndex = this.evaluateVertexIndex(vertexIndex);
        reference.texCoordIndex = this.evaluateTexCoordIndex(texCoordIndex);
        reference.normalIndex = this.evaluateNormalIndex(normalIndex);
        this.currentFace.getReferences().add(reference);
    }

    @Override
    public void onMaterialLibrary(String libraryFilename) throws WFException {
        this.model.getMaterialLibraries().add(libraryFilename);
    }

    @Override
    public void onMaterialReference(String materialName) throws WFException {
        this.assureCurrentObject();
        this.currentMesh = new OBJMesh();
        this.currentMesh.setMaterialName(materialName);
        this.currentObject.getMeshes().add(this.currentMesh);
    }

    private void assureCurrentObject() {
        if (this.currentObject != null) {
            return;
        }
        this.currentObject = new OBJObject("Default");
        this.model.getObjects().add(this.currentObject);
    }

    private void assureCurrentMesh() {
        if (this.currentMesh != null) {
            return;
        }
        this.assureCurrentObject();
        this.currentMesh = new OBJMesh();
        this.currentObject.getMeshes().add(this.currentMesh);
    }

    private int evaluateVertexIndex(IFastInt vertexIndex) {
        if (vertexIndex == null) {
            return -1;
        }
        if (vertexIndex.get() > 0) {
            return vertexIndex.get() - 1;
        }
        return this.model.getVertices().size() + vertexIndex.get();
    }

    private int evaluateTexCoordIndex(IFastInt texCoordIndex) {
        if (texCoordIndex == null) {
            return -1;
        }
        if (texCoordIndex.get() > 0) {
            return texCoordIndex.get() - 1;
        }
        return this.model.getTexCoords().size() + texCoordIndex.get();
    }

    private int evaluateNormalIndex(IFastInt normalIndex) {
        if (normalIndex == null) {
            return -1;
        }
        if (normalIndex.get() > 0) {
            return normalIndex.get() - 1;
        }
        return this.model.getNormals().size() + normalIndex.get();
    }
}

