/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.common.IFastInt;
import com.momchil_atanasov.data.front.common.OBJLimits;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.error.WFSizeException;
import com.momchil_atanasov.data.front.scanner.IOBJScannerHandler;

public class OBJLimitingScannerHandler
implements IOBJScannerHandler {
    private final IOBJScannerHandler delegate;
    private final OBJLimits limits;
    private int commentCount = 0;
    private int vertexCount = 0;
    private int texCoordCount = 0;
    private int normalCount = 0;
    private int objectCount = 0;
    private int faceCount = 0;
    private int dataReferenceCount = 0;
    private int materialLibraryCount = 0;
    private int materialReferenceCount = 0;

    public OBJLimitingScannerHandler(IOBJScannerHandler delegate, OBJLimits limits) {
        this.delegate = delegate;
        this.limits = limits;
    }

    @Override
    public void onComment(String comment) throws WFException {
        ++this.commentCount;
        if (this.commentCount > this.limits.maxCommentCount) {
            throw new WFSizeException("Too many comments.");
        }
        this.delegate.onComment(comment);
    }

    @Override
    public void onVertex(IFastFloat x, IFastFloat y, IFastFloat z, IFastFloat w) throws WFException {
        ++this.vertexCount;
        if (this.vertexCount > this.limits.maxVertexCount) {
            throw new WFSizeException("Too many vertices.");
        }
        this.delegate.onVertex(x, y, z, w);
    }

    @Override
    public void onNormal(IFastFloat x, IFastFloat y, IFastFloat z) throws WFException {
        ++this.normalCount;
        if (this.normalCount > this.limits.maxNormalCount) {
            throw new WFSizeException("Too many normals.");
        }
        this.delegate.onNormal(x, y, z);
    }

    @Override
    public void onTextureCoordinate(IFastFloat u, IFastFloat v, IFastFloat w) throws WFException {
        ++this.texCoordCount;
        if (this.texCoordCount > this.limits.maxTexCoordCount) {
            throw new WFSizeException("Too many texture coordinates.");
        }
        this.delegate.onTextureCoordinate(u, v, w);
    }

    @Override
    public void onObject(String objectName) throws WFException {
        ++this.objectCount;
        if (this.objectCount > this.limits.maxObjectCount) {
            throw new WFSizeException("Too many objects.");
        }
        this.delegate.onObject(objectName);
    }

    @Override
    public void onFaceBegin() throws WFException {
        ++this.faceCount;
        if (this.faceCount > this.limits.maxFaceCount) {
            throw new WFSizeException("Too many faces.");
        }
        this.delegate.onFaceBegin();
    }

    @Override
    public void onFaceEnd() throws WFException {
        this.delegate.onFaceEnd();
    }

    @Override
    public void onDataReference(IFastInt vertexIndex, IFastInt texCoordIndex, IFastInt normalIndex) throws WFException {
        ++this.dataReferenceCount;
        if (this.dataReferenceCount > this.limits.maxDataReferenceCount) {
            throw new WFSizeException("Too many data references.");
        }
        this.delegate.onDataReference(vertexIndex, texCoordIndex, normalIndex);
    }

    @Override
    public void onMaterialLibrary(String libraryFilename) throws WFException {
        ++this.materialLibraryCount;
        if (this.materialLibraryCount > this.limits.maxMaterialLibraryCount) {
            throw new WFSizeException("Too many material libraries.");
        }
        this.delegate.onMaterialLibrary(libraryFilename);
    }

    @Override
    public void onMaterialReference(String materialName) throws WFException {
        ++this.materialReferenceCount;
        if (this.materialReferenceCount > this.limits.maxMaterialReferenceCount) {
            throw new WFSizeException("Too many material references.");
        }
        this.delegate.onMaterialReference(materialName);
    }
}

