/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.FastInt;
import com.momchil_atanasov.data.front.common.IFastInt;
import com.momchil_atanasov.data.front.error.WFCorruptException;

class OBJScanDataReference {
    private final FastInt vertexIndex = new FastInt();
    private final FastInt texCoordIndex = new FastInt();
    private final FastInt normalIndex = new FastInt();
    private boolean hasTexCoordIndex = false;
    private boolean hasNormalIndex = false;

    public void parse(String segment) throws WFCorruptException {
        String[] references = segment.split("/");
        this.vertexIndex.set(OBJScanDataReference.parseInt(references[0]));
        boolean bl = this.hasTexCoordIndex = references.length >= 2 && !references[1].isEmpty();
        if (this.hasTexCoordIndex) {
            this.texCoordIndex.set(OBJScanDataReference.parseInt(references[1]));
        }
        boolean bl2 = this.hasNormalIndex = references.length >= 3 && !references[2].isEmpty();
        if (this.hasNormalIndex) {
            this.normalIndex.set(OBJScanDataReference.parseInt(references[2]));
        }
    }

    public IFastInt getVertexIndex() {
        return this.vertexIndex;
    }

    public IFastInt getTexCoordIndex() {
        return this.hasTexCoordIndex ? this.texCoordIndex : null;
    }

    public IFastInt getNormalIndex() {
        return this.hasNormalIndex ? this.normalIndex : null;
    }

    private static int parseInt(String text) throws WFCorruptException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new WFCorruptException("Could not parse int value.", ex);
        }
    }
}

