/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins;

import com.jme3.math.Vector4f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.scene.plugins.IrBoneWeightIndex;
import com.jme3.scene.plugins.IrMesh;
import com.jme3.scene.plugins.IrPolygon;
import com.jme3.scene.plugins.IrVertex;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IrUtils {
    private static final Logger logger = Logger.getLogger(IrUtils.class.getName());

    private IrUtils() {
    }

    private static IrPolygon[] quadToTri(IrPolygon quad) {
        float d2;
        if (quad.vertices.length == 3) {
            throw new IllegalStateException("Already a triangle");
        }
        IrPolygon[] t = new IrPolygon[]{new IrPolygon(), new IrPolygon()};
        t[0].vertices = new IrVertex[3];
        t[1].vertices = new IrVertex[3];
        IrVertex v0 = quad.vertices[0];
        IrVertex v1 = quad.vertices[1];
        IrVertex v2 = quad.vertices[2];
        IrVertex v3 = quad.vertices[3];
        float d1 = v0.pos.distanceSquared(v2.pos);
        if (d1 < (d2 = v1.pos.distanceSquared(v3.pos))) {
            t[0].vertices[0] = v0;
            t[0].vertices[1] = v1;
            t[0].vertices[2] = v3;
            t[1].vertices[0] = v1;
            t[1].vertices[1] = v2;
            t[1].vertices[2] = v3;
        } else {
            t[0].vertices[0] = v0;
            t[0].vertices[1] = v1;
            t[0].vertices[2] = v2;
            t[1].vertices[0] = v0;
            t[1].vertices[1] = v2;
            t[1].vertices[2] = v3;
        }
        return t;
    }

    public static IrMesh applySmoothingGroups(IrMesh mesh) {
        return null;
    }

    private static void toTangentsWithParity(IrVertex vertex) {
        if (vertex.tang != null && vertex.bitang != null) {
            float wCoord = vertex.norm.cross(vertex.tang).dot(vertex.bitang) < 0.0f ? -1.0f : 1.0f;
            vertex.tang4d = new Vector4f(vertex.tang.x, vertex.tang.y, vertex.tang.z, wCoord);
            vertex.tang = null;
            vertex.bitang = null;
        }
    }

    public static void toTangentsWithParity(IrMesh mesh) {
        for (IrPolygon polygon : mesh.polygons) {
            for (IrVertex vertex : polygon.vertices) {
                IrUtils.toTangentsWithParity(vertex);
            }
        }
    }

    private static void trimBoneWeights(IrVertex vertex) {
        if (vertex.boneWeightsIndices == null) {
            return;
        }
        Object[] boneWeightsIndices = vertex.boneWeightsIndices;
        if (boneWeightsIndices.length <= 4) {
            return;
        }
        boneWeightsIndices = Arrays.copyOf(boneWeightsIndices, boneWeightsIndices.length);
        Arrays.sort(boneWeightsIndices);
        boneWeightsIndices = (IrBoneWeightIndex[])Arrays.copyOf(boneWeightsIndices, 4);
        float sum = 0.0f;
        for (int i = 0; i < boneWeightsIndices.length; ++i) {
            sum += ((IrBoneWeightIndex)boneWeightsIndices[i]).boneWeight;
        }
        if (sum != 1.0f) {
            float sumToB = sum == 0.0f ? 0.0f : 1.0f / sum;
            for (int i = 0; i < boneWeightsIndices.length; ++i) {
                Object original = boneWeightsIndices[i];
                boneWeightsIndices[i] = new IrBoneWeightIndex(((IrBoneWeightIndex)original).boneIndex, ((IrBoneWeightIndex)original).boneWeight * sumToB);
            }
        }
        vertex.boneWeightsIndices = boneWeightsIndices;
    }

    public static void trimBoneWeights(IrMesh mesh) {
        for (IrPolygon polygon : mesh.polygons) {
            for (IrVertex vertex : polygon.vertices) {
                IrUtils.trimBoneWeights(vertex);
            }
        }
    }

    public static void triangulate(IrMesh mesh) {
        ArrayList<IrPolygon> newPolygons = new ArrayList<IrPolygon>(mesh.polygons.length);
        for (IrPolygon inputPoly : mesh.polygons) {
            if (inputPoly.vertices.length == 4) {
                IrPolygon[] tris = IrUtils.quadToTri(inputPoly);
                newPolygons.add(tris[0]);
                newPolygons.add(tris[1]);
                continue;
            }
            if (inputPoly.vertices.length == 3) {
                newPolygons.add(inputPoly);
                continue;
            }
            logger.log(Level.WARNING, "N-gon encountered, ignoring. The mesh may not appear correctly. Triangulate your model prior to export.");
        }
        mesh.polygons = new IrPolygon[newPolygons.size()];
        newPolygons.toArray(mesh.polygons);
    }

    public static IntMap<IrMesh> splitByMaterial(IrMesh mesh) {
        IntMap materialToPolyList = new IntMap();
        for (IrPolygon polygon : mesh.polygons) {
            int materialIndex = -1;
            for (IrVertex vertex : polygon.vertices) {
                if (vertex.material == null) continue;
                if (materialIndex == -1) {
                    materialIndex = vertex.material;
                    continue;
                }
                if (materialIndex == vertex.material) continue;
                throw new UnsupportedOperationException("Multiple materials assigned to the same polygon");
            }
            ArrayList<IrPolygon> polyList = (ArrayList<IrPolygon>)materialToPolyList.get(materialIndex);
            if (polyList == null) {
                polyList = new ArrayList<IrPolygon>();
                materialToPolyList.put(materialIndex, polyList);
            }
            polyList.add(polygon);
        }
        IntMap materialToMesh = new IntMap();
        for (IntMap.Entry entry : materialToPolyList) {
            int key = entry.getKey();
            List polygons = (List)entry.getValue();
            if (polygons.size() <= 0) continue;
            IrMesh newMesh = new IrMesh();
            newMesh.polygons = new IrPolygon[polygons.size()];
            polygons.toArray(newMesh.polygons);
            materialToMesh.put(key, (Object)newMesh);
        }
        return materialToMesh;
    }

    public static Mesh convertIrMeshToJmeMesh(IrMesh mesh) {
        HashMap<IrVertex, Integer> vertexToVertexIndex = new HashMap<IrVertex, Integer>();
        ArrayList<IrVertex> vertices = new ArrayList<IrVertex>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int vertexIndex = 0;
        for (IrPolygon polygon : mesh.polygons) {
            if (polygon.vertices.length != 3) {
                throw new UnsupportedOperationException("IrMesh must be triangulated first");
            }
            for (IrVertex vertex : polygon.vertices) {
                Integer existingIndex = (Integer)vertexToVertexIndex.get(vertex);
                if (existingIndex == null) {
                    indexes.add(vertexIndex);
                    vertexToVertexIndex.put(vertex, vertexIndex);
                    vertices.add(vertex);
                    ++vertexIndex;
                    continue;
                }
                indexes.add(existingIndex);
            }
        }
        Mesh jmeMesh = new Mesh();
        jmeMesh.setMode(Mesh.Mode.Triangles);
        FloatBuffer posBuf = null;
        FloatBuffer normBuf = null;
        FloatBuffer tangBuf = null;
        FloatBuffer uv0Buf = null;
        FloatBuffer uv1Buf = null;
        ByteBuffer colorBuf = null;
        ByteBuffer boneIndices = null;
        FloatBuffer boneWeights = null;
        IndexIntBuffer indexBuf = null;
        IrVertex inspectionVertex = (IrVertex)vertices.get(0);
        if (inspectionVertex.pos != null) {
            posBuf = BufferUtils.createVector3Buffer((int)vertices.size());
            jmeMesh.setBuffer(VertexBuffer.Type.Position, 3, posBuf);
        }
        if (inspectionVertex.norm != null) {
            normBuf = BufferUtils.createVector3Buffer((int)vertices.size());
            jmeMesh.setBuffer(VertexBuffer.Type.Normal, 3, normBuf);
        }
        if (inspectionVertex.tang4d != null) {
            tangBuf = BufferUtils.createFloatBuffer((int)(vertices.size() * 4));
            jmeMesh.setBuffer(VertexBuffer.Type.Tangent, 4, tangBuf);
        }
        if (inspectionVertex.tang != null || inspectionVertex.bitang != null) {
            throw new IllegalStateException("Mesh is using 3D tangents, must be converted to 4D tangents first.");
        }
        if (inspectionVertex.uv0 != null) {
            uv0Buf = BufferUtils.createVector2Buffer((int)vertices.size());
            jmeMesh.setBuffer(VertexBuffer.Type.TexCoord, 2, uv0Buf);
        }
        if (inspectionVertex.uv1 != null) {
            uv1Buf = BufferUtils.createVector2Buffer((int)vertices.size());
            jmeMesh.setBuffer(VertexBuffer.Type.TexCoord2, 2, uv1Buf);
        }
        if (inspectionVertex.color != null) {
            colorBuf = BufferUtils.createByteBuffer((int)(vertices.size() * 4));
            jmeMesh.setBuffer(VertexBuffer.Type.Color, 4, colorBuf);
            jmeMesh.getBuffer(VertexBuffer.Type.Color).setNormalized(true);
        }
        if (inspectionVertex.boneWeightsIndices != null) {
            boneIndices = BufferUtils.createByteBuffer((int)(vertices.size() * 4));
            boneWeights = BufferUtils.createFloatBuffer((int)(vertices.size() * 4));
            jmeMesh.setBuffer(VertexBuffer.Type.BoneIndex, 4, boneIndices);
            jmeMesh.setBuffer(VertexBuffer.Type.BoneWeight, 4, boneWeights);
            VertexBuffer weightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
            VertexBuffer indicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
            indicesHW.setUsage(VertexBuffer.Usage.CpuOnly);
            weightsHW.setUsage(VertexBuffer.Usage.CpuOnly);
            jmeMesh.setBuffer(weightsHW);
            jmeMesh.setBuffer(indicesHW);
        }
        if (vertices.size() >= 65536) {
            IntBuffer ib = BufferUtils.createIntBuffer((int)indexes.size());
            jmeMesh.setBuffer(VertexBuffer.Type.Index, 3, ib);
            indexBuf = new IndexIntBuffer(ib);
        } else {
            ShortBuffer sb = BufferUtils.createShortBuffer((int)indexes.size());
            jmeMesh.setBuffer(VertexBuffer.Type.Index, 3, sb);
            indexBuf = new IndexShortBuffer(sb);
        }
        jmeMesh.setStatic();
        int maxBonesPerVertex = -1;
        for (IrVertex vertex : vertices) {
            if (posBuf != null) {
                posBuf.put(vertex.pos.x).put(vertex.pos.y).put(vertex.pos.z);
            }
            if (normBuf != null) {
                normBuf.put(vertex.norm.x).put(vertex.norm.y).put(vertex.norm.z);
            }
            if (tangBuf != null) {
                tangBuf.put(vertex.tang4d.x).put(vertex.tang4d.y).put(vertex.tang4d.z).put(vertex.tang4d.w);
            }
            if (uv0Buf != null) {
                uv0Buf.put(vertex.uv0.x).put(vertex.uv0.y);
            }
            if (uv1Buf != null) {
                uv1Buf.put(vertex.uv1.x).put(vertex.uv1.y);
            }
            if (colorBuf != null) {
                colorBuf.putInt(vertex.color.asIntABGR());
            }
            if (boneIndices == null) continue;
            if (vertex.boneWeightsIndices != null) {
                int i;
                if (vertex.boneWeightsIndices.length > 4) {
                    throw new UnsupportedOperationException("Mesh uses more than 4 weights per bone. Call trimBoneWeights() to alleviate this");
                }
                for (i = 0; i < vertex.boneWeightsIndices.length; ++i) {
                    boneIndices.put((byte)(vertex.boneWeightsIndices[i].boneIndex & 0xFF));
                    boneWeights.put(vertex.boneWeightsIndices[i].boneWeight);
                }
                for (i = 0; i < 4 - vertex.boneWeightsIndices.length; ++i) {
                    boneIndices.put((byte)0);
                    boneWeights.put(0.0f);
                }
            } else {
                boneIndices.putInt(0);
                boneWeights.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
            }
            maxBonesPerVertex = Math.max(maxBonesPerVertex, vertex.boneWeightsIndices.length);
        }
        for (int i = 0; i < indexes.size(); ++i) {
            indexBuf.put(i, ((Integer)indexes.get(i)).intValue());
        }
        jmeMesh.updateCounts();
        jmeMesh.updateBound();
        if (boneIndices != null) {
            jmeMesh.setMaxNumWeights(maxBonesPerVertex);
            jmeMesh.prepareForAnim(true);
            jmeMesh.generateBindPose(true);
        }
        return jmeMesh;
    }
}

