/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.file;

import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;

public class FbxReader {
    public static final int BLOCK_SENTINEL_LENGTH = 13;
    public static final byte[] BLOCK_SENTINEL_DATA = new byte[13];
    public static final byte[] HEAD_MAGIC = new byte[]{75, 97, 121, 100, 97, 114, 97, 32, 70, 66, 88, 32, 66, 105, 110, 97, 114, 121, 32, 32, 0, 26, 0};

    private FbxReader() {
    }

    public static FbxFile readFBX(InputStream stream) throws IOException {
        FbxElement e;
        FbxFile fbxFile = new FbxFile();
        ByteBuffer byteBuffer = FbxReader.readToByteBuffer(stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] magic = FbxReader.getBytes(byteBuffer, HEAD_MAGIC.length);
        if (!Arrays.equals(HEAD_MAGIC, magic)) {
            throw new IOException("Either ASCII FBX or corrupt file. Only binary FBX files are supported");
        }
        fbxFile.version = FbxReader.getUInt(byteBuffer);
        while ((e = FbxReader.readFBXElement(byteBuffer)) != null) {
            fbxFile.rootElements.add(e);
        }
        return fbxFile;
    }

    private static FbxElement readFBXElement(ByteBuffer byteBuffer) throws IOException {
        long endOffset = FbxReader.getUInt(byteBuffer);
        if (endOffset == 0L) {
            return null;
        }
        long propCount = FbxReader.getUInt(byteBuffer);
        FbxReader.getUInt(byteBuffer);
        FbxElement element = new FbxElement((int)propCount);
        element.id = new String(FbxReader.getBytes(byteBuffer, FbxReader.getUByte(byteBuffer)));
        int i = 0;
        while ((long)i < propCount) {
            char dataType = FbxReader.readDataType(byteBuffer);
            element.properties.add(FbxReader.readData(byteBuffer, dataType));
            element.propertiesTypes[i] = dataType;
            ++i;
        }
        if ((long)byteBuffer.position() < endOffset) {
            while ((long)byteBuffer.position() < endOffset - 13L) {
                element.children.add(FbxReader.readFBXElement(byteBuffer));
            }
            if (!Arrays.equals(BLOCK_SENTINEL_DATA, FbxReader.getBytes(byteBuffer, 13))) {
                throw new IOException("Failed to read block sentinel, expected 13 zero bytes");
            }
        }
        if ((long)byteBuffer.position() != endOffset) {
            throw new IOException("Data length not equal to expected");
        }
        return element;
    }

    private static Object readData(ByteBuffer byteBuffer, char dataType) throws IOException {
        switch (dataType) {
            case 'Y': {
                return byteBuffer.getShort();
            }
            case 'C': {
                return byteBuffer.get() == 1;
            }
            case 'I': {
                return byteBuffer.getInt();
            }
            case 'F': {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 'D': {
                return byteBuffer.getDouble();
            }
            case 'L': {
                return byteBuffer.getLong();
            }
            case 'R': {
                return FbxReader.getBytes(byteBuffer, (int)FbxReader.getUInt(byteBuffer));
            }
            case 'S': {
                return new String(FbxReader.getBytes(byteBuffer, (int)FbxReader.getUInt(byteBuffer)));
            }
            case 'f': {
                return FbxReader.readArray(byteBuffer, 'f', 4);
            }
            case 'i': {
                return FbxReader.readArray(byteBuffer, 'i', 4);
            }
            case 'd': {
                return FbxReader.readArray(byteBuffer, 'd', 8);
            }
            case 'l': {
                return FbxReader.readArray(byteBuffer, 'l', 8);
            }
            case 'b': {
                return FbxReader.readArray(byteBuffer, 'b', 1);
            }
            case 'c': {
                return FbxReader.readArray(byteBuffer, 'c', 1);
            }
        }
        throw new IOException("Unknown data type: " + dataType);
    }

    private static Object readArray(ByteBuffer byteBuffer, char type, int bytes) throws IOException {
        int count = (int)FbxReader.getUInt(byteBuffer);
        int encoding = (int)FbxReader.getUInt(byteBuffer);
        int length = (int)FbxReader.getUInt(byteBuffer);
        byte[] data = FbxReader.getBytes(byteBuffer, length);
        if (encoding == 1) {
            data = FbxReader.inflate(data);
        }
        if (data.length != count * bytes) {
            throw new IOException("Wrong data length. Expected: " + count * bytes + ", got: " + data.length);
        }
        ByteBuffer dis = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case 'f': {
                float[] arr = new float[count];
                for (int i = 0; i < count; ++i) {
                    arr[i] = dis.getFloat();
                }
                return arr;
            }
            case 'i': {
                int[] arr2 = new int[count];
                for (int i = 0; i < count; ++i) {
                    arr2[i] = dis.getInt();
                }
                return arr2;
            }
            case 'd': {
                double[] arr3 = new double[count];
                for (int i = 0; i < count; ++i) {
                    arr3[i] = dis.getDouble();
                }
                return arr3;
            }
            case 'l': {
                long[] arr4 = new long[count];
                for (int i = 0; i < count; ++i) {
                    arr4[i] = dis.getLong();
                }
                return arr4;
            }
            case 'b': {
                boolean[] arr5 = new boolean[count];
                for (int i = 0; i < count; ++i) {
                    arr5[i] = dis.get() == 1;
                }
                return arr5;
            }
            case 'c': {
                int[] arr6 = new int[count];
                for (int i = 0; i < count; ++i) {
                    arr6[i] = dis.get() & 0xFF;
                }
                return arr6;
            }
        }
        throw new IOException("Unknown array data type: " + type);
    }

    private static byte[] inflate(byte[] input) throws IOException {
        InflaterInputStream gzis = new InflaterInputStream(new ByteArrayInputStream(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (gzis.available() > 0) {
            int l = gzis.read(buffer);
            if (l <= 0) continue;
            out.write(buffer, 0, l);
        }
        return out.toByteArray();
    }

    private static char readDataType(ByteBuffer byteBuffer) {
        return (char)byteBuffer.get();
    }

    private static long getUInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    private static int getUByte(ByteBuffer byteBuffer) {
        return byteBuffer.get() & 0xFF;
    }

    private static byte[] getBytes(ByteBuffer byteBuffer, int size) {
        byte[] b = new byte[size];
        byteBuffer.get(b);
        return b;
    }

    private static ByteBuffer readToByteBuffer(InputStream input) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        byte[] tmp = new byte[2048];
        while ((r = input.read(tmp)) != -1) {
            out.write(tmp, 0, r);
        }
        return ByteBuffer.wrap(out.toByteArray()).order(ByteOrder.LITTLE_ENDIAN);
    }
}

