/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.asset.AssetLoadException;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrackData {
    Float length;
    float[] times;
    List<TimeData> timeArrays = new ArrayList<TimeData>();
    Vector3f[] translations;
    Quaternion[] rotations;
    Vector3f[] scales;
    float[] weights;

    public void update() {
        if (this.equalTimes(this.timeArrays)) {
            this.times = this.timeArrays.get((int)0).times;
        } else {
            int i;
            ArrayList<KeyFrame> keyFrames = new ArrayList<KeyFrame>();
            TimeData timeData = this.timeArrays.get(0);
            Type type = timeData.type;
            float lastTime = -1.0f;
            for (i = 0; i < timeData.times.length; ++i) {
                float time = timeData.times[i];
                if (Float.floatToIntBits(time) == Float.floatToIntBits(lastTime)) {
                    lastTime = time;
                    continue;
                }
                lastTime = time;
                KeyFrame keyFrame = new KeyFrame();
                keyFrame.time = time;
                this.setKeyFrameTransforms(type, keyFrame, timeData.times);
                keyFrames.add(keyFrame);
            }
            for (i = 1; i < this.timeArrays.size(); ++i) {
                timeData = this.timeArrays.get(i);
                type = timeData.type;
                block2: for (float time : timeData.times) {
                    for (int j = 0; j < keyFrames.size(); ++j) {
                        KeyFrame kf = (KeyFrame)keyFrames.get(j);
                        if (Float.floatToIntBits(kf.time) != Float.floatToIntBits(time)) {
                            if (time > kf.time) continue;
                            kf = new KeyFrame();
                            kf.time = time;
                            keyFrames.add(j, kf);
                            ++j;
                        }
                        this.setKeyFrameTransforms(type, kf, timeData.times);
                        continue block2;
                    }
                }
            }
            this.times = new float[keyFrames.size()];
            this.ensureArraysLength();
            TransformIndices translationIndices = new TransformIndices();
            TransformIndices rotationIndices = new TransformIndices();
            TransformIndices scaleIndices = new TransformIndices();
            for (int i2 = 0; i2 < keyFrames.size(); ++i2) {
                KeyFrame kf = (KeyFrame)keyFrames.get(i2);
                this.times[i2] = kf.time;
                if (this.translations != null) {
                    this.populateTransform(Type.Translation, i2, keyFrames, kf, translationIndices);
                }
                if (this.rotations != null) {
                    this.populateTransform(Type.Rotation, i2, keyFrames, kf, rotationIndices);
                }
                if (this.scales == null) continue;
                this.populateTransform(Type.Scale, i2, keyFrames, kf, scaleIndices);
            }
        }
        if (this.times[0] > 0.0f) {
            float[] newTimes = new float[this.times.length + 1];
            newTimes[0] = 0.0f;
            System.arraycopy(this.times, 0, newTimes, 1, this.times.length);
            this.times = newTimes;
            if (this.translations != null) {
                Vector3f[] newTranslations = new Vector3f[this.translations.length + 1];
                newTranslations[0] = this.translations[0];
                System.arraycopy(this.translations, 0, newTranslations, 1, this.translations.length);
                this.translations = newTranslations;
            }
            if (this.rotations != null) {
                Quaternion[] newRotations = new Quaternion[this.rotations.length + 1];
                newRotations[0] = this.rotations[0];
                System.arraycopy(this.rotations, 0, newRotations, 1, this.rotations.length);
                this.rotations = newRotations;
            }
            if (this.scales != null) {
                Vector3f[] newScales = new Vector3f[this.scales.length + 1];
                newScales[0] = this.scales[0];
                System.arraycopy(this.scales, 0, newScales, 1, this.scales.length);
                this.scales = newScales;
            }
            if (this.weights != null) {
                int nbMorph = this.weights.length / (this.times.length - 1);
                float[] newWeights = new float[this.weights.length + nbMorph];
                System.arraycopy(this.weights, 0, newWeights, 0, nbMorph);
                System.arraycopy(this.weights, 0, newWeights, nbMorph, this.weights.length);
                this.weights = newWeights;
            }
        }
        this.checkTimesConsistantcy();
        this.length = Float.valueOf(this.times[this.times.length - 1]);
    }

    public void checkTimesConsistantcy() {
        if (this.translations != null && this.times.length != this.translations.length || this.rotations != null && this.times.length != this.rotations.length || this.scales != null && this.times.length != this.scales.length) {
            throw new AssetLoadException("Inconsistent animation sampling ");
        }
    }

    private void populateTransform(Type type, int index, List<KeyFrame> keyFrames, KeyFrame currentKeyFrame, TransformIndices transformIndices) {
        Object transform = this.getTransform(type, currentKeyFrame);
        if (transform != null) {
            this.getArray((Type)type)[index] = transform;
            transformIndices.last = index;
        } else {
            transformIndices.next = this.findNext(keyFrames, type, index);
            if (transformIndices.next == -1) {
                if (transformIndices.last == -1) {
                    return;
                }
                KeyFrame lastKeyFrame = keyFrames.get(transformIndices.last);
                this.getArray((Type)type)[index] = this.getTransform(type, lastKeyFrame);
                return;
            }
            KeyFrame nextKeyFrame = keyFrames.get(transformIndices.next);
            if (transformIndices.last == -1) {
                this.translations[index] = nextKeyFrame.translation;
            } else {
                KeyFrame lastKeyFrame = keyFrames.get(transformIndices.last);
                float ratio = currentKeyFrame.time / (nextKeyFrame.time - lastKeyFrame.time);
                this.interpolate(type, ratio, lastKeyFrame, nextKeyFrame, index);
            }
        }
    }

    private int findNext(List<KeyFrame> keyFrames, Type type, int fromIndex) {
        block5: for (int i = fromIndex + 1; i < keyFrames.size(); ++i) {
            KeyFrame kf = keyFrames.get(i);
            switch (type) {
                case Translation: {
                    if (kf.translation == null) continue block5;
                    return i;
                }
                case Rotation: {
                    if (kf.rotation == null) continue block5;
                    return i;
                }
                case Scale: {
                    if (kf.scale == null) continue block5;
                    return i;
                }
            }
        }
        return -1;
    }

    public int getNbKeyFrames() {
        if (this.times != null) {
            return this.times.length;
        }
        return 0;
    }

    private void interpolate(Type type, float ratio, KeyFrame lastKeyFrame, KeyFrame nextKeyFrame, int currentIndex) {
        switch (type) {
            case Translation: {
                this.translations[currentIndex] = FastMath.interpolateLinear((float)ratio, (Vector3f)lastKeyFrame.translation, (Vector3f)nextKeyFrame.translation);
                break;
            }
            case Rotation: {
                Quaternion rot = new Quaternion().set(lastKeyFrame.rotation);
                rot.nlerp(nextKeyFrame.rotation, ratio);
                this.rotations[currentIndex] = rot;
                break;
            }
            case Scale: {
                this.scales[currentIndex] = FastMath.interpolateLinear((float)ratio, (Vector3f)lastKeyFrame.scale, (Vector3f)nextKeyFrame.scale);
            }
        }
    }

    private Object[] getArray(Type type) {
        switch (type) {
            case Translation: {
                return this.translations;
            }
            case Rotation: {
                return this.rotations;
            }
            case Scale: {
                return this.scales;
            }
        }
        return this.translations;
    }

    private Object getTransform(Type type, KeyFrame kf) {
        switch (type) {
            case Translation: {
                return kf.translation;
            }
            case Rotation: {
                return kf.rotation;
            }
            case Scale: {
                return kf.scale;
            }
        }
        return kf.translation;
    }

    private void ensureArraysLength() {
        if (this.translations != null && this.translations.length != this.times.length) {
            this.translations = new Vector3f[this.times.length];
        }
        if (this.rotations != null && this.rotations.length != this.times.length) {
            this.rotations = new Quaternion[this.times.length];
        }
        if (this.scales != null && this.scales.length != this.times.length) {
            this.scales = new Vector3f[this.times.length];
        }
    }

    public void ensureTranslationRotations(Transform localTransforms) {
        int i;
        if (this.translations == null) {
            this.translations = new Vector3f[this.times.length];
            for (i = 0; i < this.translations.length; ++i) {
                this.translations[i] = localTransforms.getTranslation();
            }
        }
        if (this.rotations == null) {
            this.rotations = new Quaternion[this.times.length];
            for (i = 0; i < this.rotations.length; ++i) {
                this.rotations[i] = localTransforms.getRotation();
            }
        }
        if (this.scales == null) {
            this.scales = new Vector3f[this.times.length];
            for (i = 0; i < this.scales.length; ++i) {
                this.scales[i] = localTransforms.getScale();
            }
        }
    }

    private void setKeyFrameTransforms(Type type, KeyFrame keyFrame, float[] transformTimes) {
        int index = 0;
        while (Float.floatToIntBits(transformTimes[index]) != Float.floatToIntBits(keyFrame.time)) {
            ++index;
        }
        switch (type) {
            case Translation: {
                keyFrame.translation = this.translations[index];
                break;
            }
            case Rotation: {
                keyFrame.rotation = this.rotations[index];
                break;
            }
            case Scale: {
                keyFrame.scale = this.scales[index];
            }
        }
    }

    private boolean equalTimes(List<TimeData> timeData) {
        if (timeData.size() == 1) {
            return true;
        }
        float[] times0 = timeData.get((int)0).times;
        for (int i = 1; i < timeData.size(); ++i) {
            float[] timesI = timeData.get((int)i).times;
            if (Arrays.equals(times0, timesI)) continue;
            return false;
        }
        return true;
    }

    static class TimeData {
        float[] times;
        Type type;

        public TimeData(float[] times, Type type) {
            this.times = times;
            this.type = type;
        }
    }

    public static enum Type {
        Translation,
        Rotation,
        Scale,
        Morph;

    }

    private class KeyFrame {
        float time;
        Vector3f translation;
        Quaternion rotation;
        Vector3f scale;

        private KeyFrame() {
        }
    }

    private class TransformIndices {
        int last = -1;
        int next = -1;

        private TransformIndices() {
        }
    }
}

