/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing.serializers;

import com.jme3.network.Message;
import com.jme3.network.message.ZIPCompressedMessage;
import com.jme3.network.serializing.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZIPSerializer
extends Serializer {
    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        try {
            int read;
            ZIPCompressedMessage result = new ZIPCompressedMessage();
            byte[] byteArray = new byte[data.remaining()];
            data.get(byteArray);
            ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(byteArray));
            in.getNextEntry();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] tmp = new byte[9012];
            while (in.available() > 0 && (read = in.read(tmp)) > 0) {
                out.write(tmp, 0, read);
            }
            in.closeEntry();
            out.flush();
            in.close();
            result.setMessage((Message)Serializer.readClassAndObject(ByteBuffer.wrap(out.toByteArray())));
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (!(object instanceof ZIPCompressedMessage)) {
            return;
        }
        ZIPCompressedMessage zipMessage = (ZIPCompressedMessage)object;
        Message message = zipMessage.getMessage();
        ByteBuffer tempBuffer = ByteBuffer.allocate(512000);
        Serializer.writeClassAndObject(tempBuffer, message);
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        ZipOutputStream zipOutput = new ZipOutputStream(byteArrayOutput);
        zipOutput.setLevel(zipMessage.getLevel());
        ZipEntry zipEntry = new ZipEntry("zip");
        zipOutput.putNextEntry(zipEntry);
        tempBuffer.flip();
        zipOutput.write(tempBuffer.array(), 0, tempBuffer.limit());
        zipOutput.flush();
        zipOutput.closeEntry();
        zipOutput.close();
        buffer.put(byteArrayOutput.toByteArray());
    }
}

