/*
 * Decompiled with CFR 0.152.
 */
package flexjson.transformer;

import flexjson.transformer.Transformer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeTransformerMap
extends ConcurrentHashMap<Class, Transformer> {
    private TypeTransformerMap parentTransformerMap;
    protected boolean locked;

    public TypeTransformerMap() {
    }

    public TypeTransformerMap(TypeTransformerMap parentTransformerMap) {
        this.parentTransformerMap = parentTransformerMap;
    }

    public Transformer getTransformer(Object key) {
        LookupContext lookupContext = new LookupContext();
        Class<Void> keyClass = key == null ? Void.TYPE : key.getClass();
        Transformer transformer = this.findTransformer(keyClass, keyClass, lookupContext);
        if (transformer == null && this.parentTransformerMap != null && (transformer = this.parentTransformerMap.getTransformer(key)) != null) {
            this.putTransformer(key == null ? Void.TYPE : key.getClass(), transformer);
        }
        if (!lookupContext.isCached()) {
            this.putTransformer(keyClass, transformer);
        }
        return transformer;
    }

    private Transformer findTransformer(Class key, Class originalKey, LookupContext lookupContext) {
        if (key == null) {
            return null;
        }
        if (this.containsKey(key)) {
            if (key != originalKey) {
                lookupContext.setCached(false);
            }
            return (Transformer)this.get(key);
        }
        if (key.isArray()) {
            lookupContext.setCached(false);
            return (Transformer)this.get(Arrays.class);
        }
        for (Class<?> interfaze : key.getInterfaces()) {
            Transformer t = this.findTransformer(interfaze, originalKey, lookupContext);
            if (t == null) continue;
            return t;
        }
        return this.findTransformer(key.getSuperclass(), originalKey, lookupContext);
    }

    public Transformer putTransformer(Class aClass, Transformer transformer) {
        if (!this.locked) {
            this.put(aClass, transformer);
        }
        return transformer;
    }

    class LookupContext {
        private boolean cached;

        LookupContext() {
        }

        public boolean isCached() {
            return this.cached;
        }

        public void setCached(boolean cached) {
            this.cached = cached;
        }
    }
}

