/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.input.KeyInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.lwjgl.GlfwKeyMap;
import com.jme3.system.lwjgl.LwjglWindow;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;

public class GlfwKeyInput
implements KeyInput {
    private static final Logger logger = Logger.getLogger(GlfwKeyInput.class.getName());
    private final Queue<KeyInputEvent> keyInputEvents = new ArrayDeque<KeyInputEvent>();
    private final LwjglWindow context;
    private GLFWKeyCallback keyCallback;
    private GLFWCharCallback charCallback;
    private RawInputListener listener;
    private boolean initialized;

    public GlfwKeyInput(LwjglWindow context) {
        this.context = context;
    }

    public void initialize() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.initCallbacks();
        this.initialized = true;
        logger.fine("Keyboard created.");
    }

    public void resetContext() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        this.initCallbacks();
    }

    private void closeCallbacks() {
        this.keyCallback.close();
        this.charCallback.close();
    }

    public String getKeyName(int jmeKey) {
        int glfwKey = GlfwKeyMap.fromJmeKeyCode(jmeKey);
        if (glfwKey == -1) {
            return null;
        }
        String result = GLFW.glfwGetKeyName((int)glfwKey, (int)0);
        return result;
    }

    private void initCallbacks() {
        this.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                if (key < 0 || key > 348) {
                    return;
                }
                int jmeKey = GlfwKeyMap.toJmeKeyCode(key);
                KeyInputEvent event = new KeyInputEvent(jmeKey, '\u0000', 1 == action, 2 == action);
                event.setTime(GlfwKeyInput.this.getInputTimeNanos());
                GlfwKeyInput.this.keyInputEvents.add(event);
            }
        };
        GLFW.glfwSetKeyCallback((long)this.context.getWindowHandle(), (GLFWKeyCallbackI)this.keyCallback);
        this.charCallback = new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                char keyChar = (char)codepoint;
                KeyInputEvent pressed = new KeyInputEvent(0, keyChar, true, false);
                pressed.setTime(GlfwKeyInput.this.getInputTimeNanos());
                GlfwKeyInput.this.keyInputEvents.add(pressed);
                KeyInputEvent released = new KeyInputEvent(0, keyChar, false, false);
                released.setTime(GlfwKeyInput.this.getInputTimeNanos());
                GlfwKeyInput.this.keyInputEvents.add(released);
            }
        };
        GLFW.glfwSetCharCallback((long)this.context.getWindowHandle(), (GLFWCharCallbackI)this.charCallback);
    }

    public int getKeyCount() {
        return 316;
    }

    public void update() {
        if (!this.context.isRenderable()) {
            return;
        }
        while (!this.keyInputEvents.isEmpty()) {
            this.listener.onKeyEvent(this.keyInputEvents.poll());
        }
    }

    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        logger.fine("Keyboard destroyed.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }
}

