uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;

attribute vec3 inPosition;
attribute vec3 inNormal;

varying vec3 refVec;

void main(){
    gl_Position = g_WorldViewProjectionMatrix * vec4(inPosition,1.0);

    vec4 worldPos4 = g_WorldMatrix * vec4(inPosition,1.0);
    vec3 worldPos = worldPos4.xyz;
    vec4 inNormal4 = vec4(inNormal,1.0);
    vec4 norm4 = g_WorldMatrix * inNormal4;
    vec3 norm = norm4.xyz;
   
    vec3 I = normalize(worldPos - g_CameraPosition).xyz;
    vec3 N = normalize(norm) * -1.0;

    refVec = -1.0 * reflect(I, N);

}