uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;

attribute vec3 inPosition;
attribute vec3 inNormal;

varying vec3 refVec;
varying vec3 refVec0;
varying vec3 refVec1;
varying vec3 refVec2;
varying vec3 refVec3;

vec4 quat_conj(vec4 q)
{
    return vec4(-q.x, -q.y, -q.z, q.w);
}

vec4 quat_mult(vec4 q1, vec4 q2)
{
    vec4 qr;
    qr.x = (q1.w * q2.x) + (q1.x * q2.w) + (q1.y * q2.z) - (q1.z * q2.y);
    qr.y = (q1.w * q2.y) - (q1.x * q2.z) + (q1.y * q2.w) + (q1.z * q2.x);
    qr.z = (q1.w * q2.z) + (q1.x * q2.y) - (q1.y * q2.x) + (q1.z * q2.w);
    qr.w = (q1.w * q2.w) - (q1.x * q2.x) - (q1.y * q2.y) - (q1.z * q2.z);
    return qr;
}

vec4 quat_from_axis_angle(vec3 axis, float angle)
{
    vec4 qr;
    float half_angle = (angle * 0.5);
    qr.x = axis.x * sin(half_angle);
    qr.y = axis.y * sin(half_angle);
    qr.z = axis.z * sin(half_angle);
    qr.w = cos(half_angle);
    return qr;
}

vec3 rotate_vertex_position(vec3 position, vec3 axis, float angle)
{
    vec4 q = quat_from_axis_angle(axis, angle);
    vec3 v = position.xyz;
    return v + 2.0 * cross(q.xyz, cross(q.xyz, v) + q.w * v);
}



void main(){
    gl_Position = g_WorldViewProjectionMatrix * vec4(inPosition,1.0);

    vec4 worldPos4 = g_WorldMatrix * vec4(inPosition,1.0);
    vec3 worldPos = worldPos4.xyz;
    vec4 inNormal4 = vec4(inNormal,1.0);
    vec4 norm4 = g_WorldMatrix * inNormal4;
    vec3 norm = norm4.xyz;
   
    vec3 I = normalize(worldPos - g_CameraPosition).xyz;
    vec3 N = normalize(norm) * -1.0;

    refVec = -1.0 * reflect(I, N);
    
    //float f = 0.5;
    //vec3 worldPos1 = vec3(worldPos.x * f, worldPos.y * f, worldPos.z * f);
    //vec3 I1 = normalize(worldPos1 - g_CameraPosition).xyz;
    //refVec2 = -1.0 * reflect(I1, N);

    float Angle = radians( 0.3 * (0.05 + ( refVec.y) )  ); // 0.2°

    vec3 YAXIS = vec3(0.0,1.0,0.0);
    vec3 rotAXIS = cross(refVec, YAXIS);
    
    refVec0 = normalize( rotate_vertex_position(refVec, YAXIS, Angle) );
    refVec1 = normalize( rotate_vertex_position(refVec, YAXIS, -1.0 * Angle) );
    
    refVec2 = normalize( rotate_vertex_position(refVec, rotAXIS, Angle) );
    refVec3 = normalize( rotate_vertex_position(refVec, rotAXIS, -1.0 * Angle) );

    
}
/*
 vec3 P = rotate_vertex_position(gxl3d_Position.xyz, T.axis_angle.xyz, T.axis_angle.w);
 P += T.position.xyz;
 gl_Position = gxl3d_ViewProjectionMatrix * vec4(P, 1);
 
 */
